//crossroads
//Helter Skelter, http://www.godsmonsters.com/Skelter/

#version 3.5;
#include "colors.inc"

global_settings {
	assumed_gamma 1.0
}

camera {
	location  <0.0, 0.5, -4.5>
	direction 1.5*z
	right     x*image_width/image_height
	look_at   <0.0, 0.0,  0.0>
}

light_source {
	<0, 100, -100>
	color White
}

#declare pillarRadius = .15;

union {
	torus {
		1, pillarRadius
		
		rotate <90, 0, 0>
		
	}
	
	#declare pillarLength = 1.4;
	
	cylinder {
		<0, -pillarLength, 0>,
		<0, pillarLength, 0>,
		pillarRadius
		
	}
	
	cylinder {
		<-pillarLength, 0, 0>,
		<pillarLength, 0, 0>,
		pillarRadius
		
	}

	pigment  {
		gradient x
		turbulence .3
		color_map {
			[0.000 color rgbft <1.0, 0.5, 1.0, 0.0, 0.0 > ]	//violet 1
			[0.100 color rgbft <1.0, 0.5, 1.0, 0.0, 0.0 > ]	//violet 2
			[0.214 color rgbft <0.5, 0.5, 1.0, 0.0, 0.0 > ]	//indigo
			[0.328 color rgbft <0.2, 0.2, 1.0, 0.0, 0.0 > ]	//blue
			[0.442 color rgbft <0.2, 1.0, 1.0, 0.0, 0.0 > ]	//cyan
			[0.556 color rgbft <0.2, 1.0, 0.2, 0.0, 0.0 > ]	//green
			[0.670 color rgbft <1.0, 1.0, 0.2, 0.0, 0.0 > ]	//yellow
			[0.784 color rgbft <1.0, 0.5, 0.2, 0.0, 0.0 > ]	//orange
			[0.900 color rgbft <1.0, 0.2, 0.2, 0.0, 0.0 > ]	//red1
			[1.000 color rgbft <1.0, 0.2, 0.2, 0.0, 0.0 > ]	//red2
		}
		
		scale .8
		rotate <0, 0, 45>
	}

}

background  {
	color rgb < 1, 1, 1 > 
}
